function init_plugin() {

    var test = false;
    
    function findGetParameter(parameterName, link) {
        var result = null, tmp = [], urlparams = []; 
        if(link === undefined) {
            urlparams = location.search.substr(1).split("&");
        }else {
            var _substr = link.split("?");
            if(_substr.length < 2) {
                return result;
            }
            urlparams = _substr[1].split("&");
        }        
        for (var index = 0; index < urlparams.length; index++) {
            tmp = urlparams[index].split("=");
            if (tmp[0] === parameterName) result = decodeURIComponent(tmp[1]);
        }
        return result;
    }
    
    var f = findGetParameter("f"), topic = findGetParameter("showtopic"); 
    if(location.href.indexOf('file:///') === 0) {
        test = true; f=29; topic=5232547;
    }

    if(f != 29 || topic == null) {
        return;
    }
    
    var form =  $('form[name="MDEL"]').first();
    if(form.length == 0) {
        return;
    }

    var user_id = 0;
    if($('#userlinks').length == 1) {
        var user_a = $('#userlinks').find('a');
        if(user_a.length > 0) {
            user_id = findGetParameter("showuser", user_a[0].href);
            if(user_id == null) {
                user_id = 0;
            }else {
                user_id = parseInt(user_id);
                if(!user_id) {
                    user_id = 0;
                }
            }
        }
    }

    var tables =  form.find('table'), posts = {}, post_ids = [];
    tables.each(function () {
        var tr = $(this).find('tr');
        if(tr.length != 0){
            var td = tr.find('td');
            if(td.length > 0){
                var a = $(td[1]).find('a');
                if(a.length != 0) {
                    var post_link = a.first().attr("onclick");
                    if(post_link) {
                        var p1 = post_link.indexOf('('), p2 = post_link.indexOf(')');
                        if(p1 !==false && p2 !==false) {
                            post_link = post_link.substr(p1 + 1, p2 - p1 -1);
                            post_id = parseInt(post_link);
                            if(post_id) {
                                post_ids.push(post_id)
                                posts[post_id] = {id : post_id,td : td.first()};
                            }                
                        }                
                    }                
                }
            }
        }
    });

    if(post_ids.length > 0) {
          get_ratings(post_ids);
    }
    
    function get_ratings(post_ids) {
        $.ajax({
            type: "POST",
            url: server() + 'posts_ratings/ratings',
            dataType: 'json',
            async: false,
            data:{"topic":topic, "user_id":user_id, "post_ids":post_ids},
            success: function (response) {
              if(response.success && response.results) {
                show_ratings(response.results, response.ratings_block)
              }else {console.log("wrong response!");}            
            },
            error: function(){console.log("error!");}
        });
    }
    function server() {return 'https://www.aspurcela.ge/forumge/';}
    function show_ratings(response, ratings_block) {    
        var el = document.getElementsByClassName('posts_rating');
        while(el[0]) {
            el[0].parentNode.removeChild(el[0]);
        }

        // prepare ratings block
        if(ratings_block === undefined || ratings_block == '') {
          ratings_block = '<table class="posts_rating"><tr data-post="post_id"><td class="vp">@p</td><th class="vm">@m</th></tr><tr><td colspan="2" class="rating_msg"></td></tr></table>';
        }

        for(var i = 0, n = response.length; i < n; i++) {
            if(response[i].length != 5) continue;
            var post_id = response[i][0], plus = response[i][1], minus = response[i][2], voted = response[i][3]
            if(posts[post_id] !== undefined) {
                var block = ratings_block;
                block = block.replace('@p', plus);
                block = block.replace('@m', minus);
                block = block.replace('post_id', post_id);
                if(voted) {
                    if(voted == 1) {
                        block = block.replace('posts_rating', 'posts_rating post_voted_plus');
                    }else if(voted == -1) {
                        block = block.replace('posts_rating', 'posts_rating post_voted_minus');
                    } 
                }
                posts[post_id].td.append(block)
            }
        }

        $('.posts_rating .vp, .posts_rating .vm').unbind('click').on('click', function () {
            var _this = $(this), _container = _this.closest('.posts_rating');
            if(_container.hasClass('post_voted_plus') || _container.hasClass('post_voted_minus')) return;
            var _class = _this.attr('class'), post_id = _this.parent().data('post'), val = 0;            
            if(_class == 'vp') {
              val = 1;
            }else if(_class == 'vm') {
              val = -1;
            }
            if(val != 0 && post_id) {
                $.ajax({
                    type: "POST",
                    url: server() + '/posts_ratings/vote/',
                    dataType: 'json',
                    async: false,
                    data:{"topic":topic, "post_id":post_id, "user_id":user_id, "val":val},
                    success: function (response) {
                        if(response.success) { 
                            get_ratings(post_ids);  // refresh posts rates
                        }else {
                            if(response.message !== undefined && response.message != '') {
                                var msg_block = _container.find('.rating_msg');
                                if(msg_block.length > 0) {
                                    msg_block.first().html(response.message)
                                }
                            }
                        }
                    },
                    error: function(){console.log("error!");}
                });
            }
        });
    }
}
init_plugin();
